SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_REMINDER_TO_APPLY_RECIPIENT'); 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T2.fatherFirstName AS PARENT_FIRSTNAME,
    T2.fatherLastName AS PARENT_LASTNAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T6.addressText,' ',T7.cityName,', ',T8.countryName,', ',T9.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T6.phoneCountryCode,'-',T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T6.websiteURL AS WEBSITE_URL,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneNo AS MOBILE_NO,
    T1.phoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    enquiry T1 
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
		LEFT OUTER JOIN
	city T7 ON T7.id = T6.cityId
		LEFT OUTER JOIN
	country T8 ON T8.id = T7.countryId
		LEFT OUTER JOIN
	country_region T9 ON T9.id = T7.countryRegionId
        LEFT JOIN
    organizations org on org.id = (select max(id) from organizations)
WHERE
    T1.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "fatherFirstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "fatherLastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "Academy Location Phone No.",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "Academy Location Email Id",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
}' WHERE (`dataProviderId` = @dtproviderId);
SET SQL_SAFE_UPDATES=1;